{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 05.09.98 - 21:45:25 $                                        =}
{========================================================================}
unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  MMDSEdtr, MMDSPObj, MMWave, MMDSMix, MMObj, ExtCtrls, StdCtrls, MMSlider,
  MMCstDlg, MMDIBCv, MMLevel, MMCCon, MMDSCon;

type
  TForm1 = class(TForm)
    Mixer: TMMDSWaveMixer;
    Ch1: TMMDSMixChannel;
    StartBtn: TButton;
    StopBtn: TButton;
    Timer1: TTimer;
    SceneGroup: TRadioGroup;
    Timer3: TTimer;
    FileBtn: TButton;
    FreqSlider: TMMSlider;
    Label1: TLabel;
    VolSlider: TMMSlider;
    Label2: TLabel;
    MMWaveOpenDialog1: TMMWaveOpenDialog;
    Timer2: TTimer;
    MMDSChannelConnector1: TMMDSChannelConnector;
    MMLevel1: TMMLevel;
    procedure StartBtnClick(Sender: TObject);
    procedure StopBtnClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure Timer3Timer(Sender: TObject);
    procedure FreqSliderChange(Sender: TObject);
    procedure VolSliderChange(Sender: TObject);
    procedure FileBtnClick(Sender: TObject);
    procedure Timer2Timer(Sender: TObject);
  private
    FStart: Integer;
  public
  end;

var
  Form1: TForm1;

implementation

uses MMDebug;

{$R *.DFM}

procedure TForm1.StartBtnClick(Sender: TObject);
begin
  Mixer.Open;
  StopBtn.Enabled := True;
  StartBtn.Enabled := False;
  FileBtn.Enabled := False;
  SceneGroup.Enabled := False;

  case SceneGroup.ItemIndex of
    0:
      begin
        Ch1.Looping := False;
        Timer1.Enabled := True;
        Timer1Timer(Self);
      end;
    1:
      begin
        FStart := GetCurrentTime;
        Ch1.Looping := True;
        Ch1.Play;
        Timer2.Enabled := True;
      end;
    2:
      begin
        FStart := GetCurrentTime;
        Ch1.Looping := True;
        Ch1.Play;
        Timer3.Enabled := True;
      end;
  end;
  VolSlider.Position := Ch1.Volume;
  FreqSlider.Position := Ch1.Frequency;
end;

procedure TForm1.StopBtnClick(Sender: TObject);
begin
  Timer1.Enabled := False;
  Timer2.Enabled := False;
  Timer3.Enabled := False;
  Mixer.Close;
  StopBtn.Enabled := False;
  StartBtn.Enabled := True;
  FileBtn.Enabled := True;
  SceneGroup.Enabled := True;
end;

procedure TForm1.FreqSliderChange(Sender: TObject);
begin
  Ch1.Frequency := FreqSlider.Position;
end;

procedure TForm1.VolSliderChange(Sender: TObject);
begin
  Ch1.Volume := VolSlider.Position;
end;

procedure TForm1.FileBtnClick(Sender: TObject);
begin
  with MMWaveOpenDialog1 do
    if Execute then
      Ch1.Wave.FileName := FileName
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
  with Ch1 do
  begin
    with Sound3D.Position do
    begin
      X := Random * 10 - 5;
      Y := 0;
      Z := 1 + Sqr(Random * 4);
    end;
    with Sound3D.Velocity do
    begin
      X := 0;
      Z := 0;
    end;
    Play;
  end;
end;

procedure TForm1.Timer2Timer(Sender: TObject);
{
           /  - Trajectory (length 2L)
          /
         /
        / *   - Observer
       /
      /
}
const
  L = 20;
  T = 5;
  Alpha = Pi / 6;
var
  Time: Integer;
begin
  Time := (GetCurrentTime - FStart) mod (T * 1000);
  with Ch1.Sound3D do
  begin
    Position.X := L * Sin(Alpha) * (1 - 2 * Time / (T * 1000));
    Position.Z := L * Cos(Alpha) * (1 - 2 * Time / (T * 1000)) + 0.2;
    Velocity.X := - (2 * L / T) * Sin(Alpha);
    Velocity.Z := - (2 * L / T) * Cos(Alpha);
    DB_FormatLn(0, '%5.3g, X = %5.3g, Z = %5.3g',
      [Time / (T * 1000), Position.X, Position.Z]);
  end;
end;

procedure TForm1.Timer3Timer(Sender: TObject);
{        ---
        /   \
       /     \
      |       |
      |   *   |
      |       |
       \     /
        \   /
         ---
}
const
  R = 5;
  T = 3;
var
  Time: Integer;
  Angle: double;
begin
  Time := GetCurrentTime - FStart;
  Angle := 2 * Pi * Time / (T * 1000);
  with Ch1.Sound3D do
  begin
    Position.X := R * Sin(Angle);
    Position.Z := R * Cos(Angle);
    Velocity.X := R * (2 * Pi * R / T) * Cos(Angle);
    Velocity.Z := R * (2 * Pi * R / T) * Sin(Angle);
  end;
end;

end.
